%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%------------Function that computes regret and implements cost-------------

function[regret,upper_interval, lower_interval, treatment_1, treatment_2] = ...
    f_regret_and_cost(treatment_1, treatment_2, lower_interval, upper_interval...
    , method, VA_trick, accuracy, cost_1, cost_2);

n_1 = numel(treatment_1);
n_2 = numel(treatment_2);
cost = [cost_1 cost_2];

if method == 0;    
    regret = 0.17 / ( ((2*n_2)-0.2)^(1/2) );
else;
    n_truncated = round( ceil(n_2/2) ) * 2;
    regret = 0.17 / ( ((n_truncated)-0.2)^(1/2) );
end;

upper_interval = upper_interval - min(cost);
lower_interval = lower_interval - max(cost);

treatment_1 = treatment_1 - cost_1*ones(n_1,1);
treatment_2 = treatment_2 - cost_2*ones(n_2,1);